
<?php $__env->startSection('title', 'Ledger Types'); ?>

<?php $__env->startSection('content'); ?>
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-2xl tw-font-bold">Ledger Types</h1>
</section>

<section class="content">
    <?php $__env->startComponent('components.widget', ['class' => 'box-primary', 'title' => 'Ledger Types List']); ?>
        
        <?php if(session('success')): ?>
            <div class="alert alert-success"><?php echo e(session('success'), false); ?></div>
        <?php endif; ?>

        <div class="mb-3">
            <a href="<?php echo e(route('ledger-types.create'), false); ?>" class="btn btn-primary">
                <i class="fa fa-plus"></i> Add New Ledger Type
            </a>
        </div>

        <div class="table-responsive">
            <table class="table table-bordered table-striped">
                <thead class="bg-light">
                    <tr>
                        <th>Name</th>
                        <th>Description</th>
                        <th>Active</th>
                        <th>Subcategories</th>
                        <th class="text-center">Actions</th>
                    </tr>
                </thead>
                <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td><?php echo e($t->name, false); ?></td>
                        <td><?php echo e(\Illuminate\Support\Str::limit($t->description, 80), false); ?></td>
                        <td>
                            <span class="badge <?php echo e($t->is_active ? 'badge-success' : 'badge-danger', false); ?>">
                                <?php echo e($t->is_active ? 'Active' : 'Inactive', false); ?>

                            </span>
                        </td>
                        <td><?php echo e($t->subcategories()->count(), false); ?></td>
                        <td class="text-center">
                            <a href="<?php echo e(route('ledger-types.edit', $t->id), false); ?>" 
                               class="btn btn-sm btn-outline-primary">
                                <i class="fa fa-edit"></i> Edit
                            </a>

                            <form action="<?php echo e(route('ledger-types.destroy', $t->id), false); ?>" 
                                  method="POST" class="d-inline"
                                  onsubmit="return confirm('Delete this ledger type? This will also remove its subcategories.')">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button class="btn btn-sm btn-danger">
                                    <i class="fa fa-trash"></i> Delete
                                </button>
                            </form>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="5" class="text-center text-muted">No ledger types found.</td>
                    </tr>
                <?php endif; ?>
                </tbody>
            </table>
        </div>

        <div class="mt-3">
            <?php echo e($types->links(), false); ?>

        </div>
    <?php echo $__env->renderComponent(); ?>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\projects\pos_ultimate\resources\views/ledger_types/index.blade.php ENDPATH**/ ?>