
<?php $__env->startSection('title', 'Edit Cash in Hand Entry'); ?>

<?php $__env->startSection('content'); ?>
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-2xl tw-font-bold">Edit Cash in Hand Entry</h1>
</section>

<section class="content">
    <?php $__env->startComponent('components.widget', ['class' => 'box-primary', 'title' => 'Update Cash in Hand Entry']); ?>
        <form method="POST" action="<?php echo e(route('cashinhand.update', $entry->id), false); ?>">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>

            <div class="row">
                <!-- Date -->
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="entry_date">Date:*</label>
                        <div class="input-group">
                            <span class="input-group-text"><i class="bi bi-calendar-date"></i></span>
                            <?php echo Form::date('entry_date', old('entry_date', $entry->entry_date->format('Y-m-d')), [
                                'class' => 'form-control',
                                'id' => 'entry_date',
                                'required'
                            ]); ?>

                        </div>
                        <?php $__errorArgs = ['entry_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> 
                            <span class="text-danger"><?php echo e($message, false); ?></span> 
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>

                <!-- Ledger Type -->
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="ledger_type_id">Ledger Type:*</label>
                        <select name="ledger_type_id" id="ledger_type_id"
                                class="form-control select2 <?php $__errorArgs = ['ledger_type_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                            <option value="">-- Select Type --</option>
                            <?php $__currentLoopData = $ledgerTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($type->id, false); ?>" 
                                    <?php echo e(old('ledger_type_id', $entry->ledger_type_id) == $type->id ? 'selected' : '', false); ?>>
                                    <?php echo e($type->name, false); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php $__errorArgs = ['ledger_type_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message, false); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>

                <!-- Ledger Subcategory -->
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="ledger_subcategory_id">Ledger Subcategory:*</label>
                        <select name="ledger_subcategory_id" id="ledger_subcategory_id"
                                class="form-control select2 <?php $__errorArgs = ['ledger_subcategory_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                            <option value="">-- Select Subcategory --</option>
                            <?php $__currentLoopData = $subcategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($sc->id, false); ?>" 
                                    <?php echo e(old('ledger_subcategory_id', $entry->ledger_subcategory_id) == $sc->id ? 'selected' : '', false); ?>>
                                    <?php echo e($sc->name, false); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php $__errorArgs = ['ledger_subcategory_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message, false); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
            </div>

            <div class="row">
                <!-- Amount -->
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="amount">Amount:*</label>
                        <?php echo Form::number('amount', old('amount', $entry->amount), [
                            'class' => 'form-control',
                            'step'  => '0.01',
                            'required',
                            'placeholder' => 'Enter amount'
                        ]); ?>

                        <?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message, false); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>

                <!-- Detail -->
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="detail">Detail:*</label>
                        <?php echo Form::text('detail', old('detail', $entry->detail), [
                            'class' => 'form-control',
                            'required',
                            'placeholder' => 'Enter detail'
                        ]); ?>

                        <?php $__errorArgs = ['detail'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message, false); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>

                <!-- Dr/Cr -->
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="dr_cr">Dr / Cr:*</label>
                        <div class="d-flex align-items-center">
                            <div class="form-check me-3">
                                <input type="radio" name="dr_cr" id="dr" value="dr" 
                                    class="form-check-input"
                                    <?php echo e(old('dr_cr', $entry->dr_cr) == 'dr' ? 'checked' : '', false); ?> required>
                                <label class="form-check-label" for="dr">Debit</label>
                            </div>

                            <div class="form-check">
                                <input type="radio" name="dr_cr" id="cr" value="cr" 
                                    class="form-check-input"
                                    <?php echo e(old('dr_cr', $entry->dr_cr) == 'cr' ? 'checked' : '', false); ?>>
                                <label class="form-check-label" for="cr">Credit</label>
                            </div>
                        </div>
                        <?php $__errorArgs = ['dr_cr'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message, false); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
            </div>

            <!-- Submit -->
            <div class="col-md-12 mt-3">
                <button type="submit" class="btn btn-primary">Update</button>
                <a href="<?php echo e(route('cashinhand.index'), false); ?>" class="btn btn-default">Cancel</a>
            </div>
        </form>
    <?php echo $__env->renderComponent(); ?>
</section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
<script>
    $(document).ready(function () {
        let typeId = $('#ledger_type_id').val();
        let subcatDropdown = $('#ledger_subcategory_id');

        function loadSubcategories(typeId, selectedId = null) {
            if (typeId) {
                let url = "<?php echo e(url('/ledger-types'), false); ?>/" + typeId + "/subcategories";
                fetch(url)
                    .then(res => res.json())
                    .then(data => {
                        let options = '<option value="">-- Please Select Subcategory From List --</option>';
                        data.forEach(sc => {
                            options += `<option value="${sc.id}" ${selectedId == sc.id ? 'selected' : ''}>${sc.name}</option>`;
                        });
                        subcatDropdown.html(options);
                    });
            } else {
                subcatDropdown.html('<option value="">-- Select Subcategory --</option>');
            }
        }

        // Load subcategories on page load
        loadSubcategories(typeId, "<?php echo e(old('ledger_subcategory_id', $entry->ledger_subcategory_id), false); ?>");

        // Reload subcategories on ledger type change
        $('#ledger_type_id').on('change', function () {
            loadSubcategories($(this).val());
        });
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\projects\pos_ultimate\resources\views/cashinhand/edit.blade.php ENDPATH**/ ?>