<?php $__env->startSection('title', __('Business Partners')); ?>

<?php $__env->startSection('content'); ?>

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black"><?php echo app('translator')->get('Business Partners'); ?>
        <small class="tw-text-sm md:tw-text-base tw-text-gray-700 tw-font-semibold"><?php echo app('translator')->get('Manage Your Business Partners'); ?></small>
    </h1>
</section>


<!-- Main content -->
<section class="content">
    <?php $__env->startComponent('components.widget', ['class' => 'box-primary', 'title' => __( 'All Your Business Partners' )]); ?>
        <?php $__env->slot('tool'); ?>
            <div class="box-tools">
                <button class="tw-dw-btn tw-bg-gradient-to-r tw-from-indigo-600 tw-to-blue-500 tw-font-bold tw-text-white tw-border-none tw-rounded-full pull-right tw-mb-2 btn-modal"
                    data-href="<?php echo e(action([\App\Http\Controllers\BusinessPartnerController::class, 'create']), false); ?>" 
                    data-container=".partner_add_modal">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor"
                        stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                        class="icon icon-tabler icons-tabler-outline icon-tabler-plus">
                        <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                        <path d="M12 5l0 14" />
                        <path d="M5 12l14 0" />
                    </svg> <?php echo app('translator')->get('messages.add'); ?>
                </button>
            </div>
        <?php $__env->endSlot(); ?>

        <div class="table-responsive">
            <table class="table table-bordered table-striped" id="business_Partners_table">
                <thead>
                    <tr>
                        <th><?php echo app('translator')->get('Business Partner Name'); ?></th>
                        <th><?php echo app('translator')->get('Business Partner Email'); ?></th>
                        <th><?php echo app('translator')->get('Business Partner Phone'); ?></th>
                        <th><?php echo app('translator')->get('Business Partner Address'); ?></th>
                        <th><?php echo app('translator')->get('Business Partner Percentage'); ?></th>
                        <!-- <th><?php echo app('translator')->get('Business Partner City'); ?></th>
                        <th><?php echo app('translator')->get('Business Partner Country'); ?></th> -->
                        <th><?php echo app('translator')->get('Business Partner Status'); ?></th>
                        <th><?php echo app('translator')->get('messages.action'); ?></th>
                    </tr>
                </thead>
            </table>
        </div>
    <?php echo $__env->renderComponent(); ?>

    <div class="modal fade partner_add_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel"></div>
    <div class="modal fade partner_edit_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel"></div>
</section>
<!-- /.content -->

<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
<script>
$(document).ready(function () {
    $('#business_Partners_table').DataTable({
        processing: true,
        serverSide: true,
        // paging: true,          // keep pagination
        // searching: true,       // keep search box
        // lengthChange: false,   // hides "Show X entries" dropdown
        // dom: 't<"bottom"p>',   // removes export buttons, keeps only table + pagination
        ajax: '<?php echo e(action([\App\Http\Controllers\BusinessPartnerController::class, "index"]), false); ?>',
        columns: [
            { data: 'name', name: 'name' },
            { data: 'email', name: 'email' },
            { data: 'phone', name: 'phone' },
            { data: 'address', name: 'address' },
            { data: 'percentage', name: 'percentage' },
            { data: 'status', name: 'status' }, // make sure you added `status` in DB + model
            { data: 'action', name: 'action', orderable: false, searchable: false }
        ]
    });

    $(document).on('click', '.btn-modal', function(e) {
        e.preventDefault();
        let container = $(this).data('container');
        let href = $(this).data('href');
        $.ajax({
            url: href,
            type: 'GET',
            success: function(result) {
                $(container).html(result);
                $(container).modal('show');
            }
        });
    });

    // Toastr messages
    <?php if(session('success')): ?>
        toastr.success("<?php echo e(session('success'), false); ?>");
    <?php endif; ?>

    <?php if(session('error')): ?>
        toastr.error("<?php echo e(session('error'), false); ?>");
    <?php endif; ?>

    $(document).on('click', '.delete_partner_button', function(e) {
        e.preventDefault();
        let url = $(this).data('href');

        if (confirm("Are you sure you want to delete this partner?")) {
            $.ajax({
                url: url,
                type: 'DELETE',
                data: {
                    _token: '<?php echo e(csrf_token(), false); ?>' // Laravel CSRF token
                },
                success: function(response) {
                    toastr.success("Partner deleted successfully!");
                    $('#business_Partners_table').DataTable().ajax.reload(); // refresh DataTable
                },
                error: function(xhr) {
                    toastr.error("Something went wrong. Please try again!");
                }
            });
        }
        });

});
</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/devyarprojects/posulimate.devyarprojects.com/resources/views/business_partners/index.blade.php ENDPATH**/ ?>