
<?php $__env->startSection('title', 'Ledger Report'); ?>

<?php $__env->startSection('content'); ?>
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-2xl tw-font-bold">Ledger Report</h1>
</section>

<section class="content">
    <?php $__env->startComponent('components.widget', ['class' => 'box-primary', 'title' => 'Ledger Report Filters']); ?>
        <!-- Filter Row -->
        <div class="row tw-mb-5">
            <div class="col-md-3">
                <label for="from_date">From Date:</label>
                <input type="text" id="from_date" name="from_date" 
                       class="form-control" 
                       value="<?php echo e(now()->startOfMonth()->toDateString(), false); ?>" 
                       autocomplete="off">
            </div>

            <div class="col-md-3">
                <label for="to_date">To Date:</label>
                <input type="text" id="to_date" name="to_date" 
                       class="form-control" 
                       value="<?php echo e(now()->toDateString(), false); ?>" 
                       autocomplete="off">
            </div>

            <div class="col-md-3">
                <label for="ledger_type_id">Ledger Type:</label>
                <select id="ledger_type_id" name="ledger_type_id" class="form-control">
                    <option value="">All Types</option>
                    <?php $__currentLoopData = $ledgerTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($type->id, false); ?>"><?php echo e($type->name, false); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            <div class="col-md-3">
                <label for="ledger_subcategory_id">Ledger Subcategory:</label>
                <select id="ledger_subcategory_id" name="ledger_subcategory_id" class="form-control">
                    <option value="">All Subcategories</option>
                </select>
            </div>
        </div>

        <div class="row tw-mb-5">
            <div class="col-md-12">
                <button type="button" id="filter_btn" class="btn btn-primary">
                    <i class="fa fa-filter"></i> Filter
                </button>
                <button type="button" id="reset_btn" class="btn btn-default">
                    <i class="fa fa-refresh"></i> Reset
                </button>
            </div>
        </div>

        <hr>

        <!-- Table -->
        <div class="table-responsive">
            <table class="table table-bordered table-striped" id="ledger_report_table">
                <thead class="bg-light">
                    <tr>
                        <th>#</th>
						<th>Date</th>
						<th>Ledger Type</th>
						<th>Ledger Subcategory</th>
						<th>Detail</th>
						<th>Debit</th>
						<th>Credit</th>
						<!-- <th>Created By</th> -->
                    </tr>
                </thead>
            </table>
        </div>
    <?php echo $__env->renderComponent(); ?>
</section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
<script>
$(function () {
    // Init datepickers
    $('#from_date, #to_date').datepicker({
        format: 'yyyy-mm-dd',
        autoclose: true,
        todayHighlight: true
    });

    // Load subcategories when ledger type changes
    $('#ledger_type_id').on('change', function() {
        let typeId = $(this).val();
        $('#ledger_subcategory_id').empty().append('<option value="">Loading...</option>');

        if (typeId) {
            $.get(`/ledger-types/${typeId}/subcategories`, function (data) {
                $('#ledger_subcategory_id').empty().append('<option value="">All Subcategories</option>');
                $.each(data, function (key, sub) {
                    $('#ledger_subcategory_id').append(`<option value="${sub.id}">${sub.name}</option>`);
                });
            });
        } else {
            $('#ledger_subcategory_id').empty().append('<option value="">All Subcategories</option>');
        }
    });

    // Init DataTable
    let table = $('#ledger_report_table').DataTable({
        processing: true,
        serverSide: true,
        ajax: {
            url: '<?php echo e(route("cashinhand.ledger.report.data"), false); ?>',
            data: function (d) {
                d.from = $('#from_date').val();
                d.to = $('#to_date').val();
                d.ledger_type_id = $('#ledger_type_id').val();
                d.ledger_subcategory_id = $('#ledger_subcategory_id').val();
            }
        },
        columns: [
		    { data: 'sr_no', name: 'sr_no', orderable: false, searchable: false },
		    { data: 'entry_date', name: 'entry_date' },
		    { data: 'ledger_type', name: 'ledgerType.name' },
		    { data: 'ledger_subcategory', name: 'ledgerSubcategory.name' },
		    { data: 'detail', name: 'detail' },
		    { data: 'debit', name: 'debit' },
		    { data: 'credit', name: 'credit' }
		    // { data: 'created_by', name: 'creator.name' }
		]
    });

    // Filter button
    $('#filter_btn').on('click', function() {
        table.ajax.reload();
    });

    // Reset button
    $('#reset_btn').on('click', function() {
        $('#from_date').val('<?php echo e(now()->startOfMonth()->toDateString(), false); ?>');
        $('#to_date').val('<?php echo e(now()->toDateString(), false); ?>');
        $('#ledger_type_id').val('');
        $('#ledger_subcategory_id').empty().append('<option value="">All Subcategories</option>');
        table.ajax.reload();
    });
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/devyarprojects/posulimate.devyarprojects.com/resources/views/cashinhand/ledger_report.blade.php ENDPATH**/ ?>