
<?php $__env->startSection('title', 'Profit / Loss Report'); ?>

<?php $__env->startSection('content'); ?>
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-2xl tw-font-bold">Profit / Loss Report</h1>
</section>

<section class="content">
    <?php $__env->startComponent('components.widget', ['class' => 'box-primary', 'title' => 'Profit / Loss Summary']); ?>

    <div class="row tw-mb-5">
        <div class="col-md-3">
            <label>From Date:</label>
            <input type="text" id="from_date" class="form-control" 
                value="<?php echo e(now()->startOfMonth()->format('Y-m-d'), false); ?>" autocomplete="off">
        </div>
        <div class="col-md-3">
            <label>To Date:</label>
            <input type="text" id="to_date" class="form-control" 
                value="<?php echo e(now()->endOfMonth()->format('Y-m-d'), false); ?>" autocomplete="off">
        </div>
        <div class="col-md-2 tw-mt-6">
            <button id="filter_btn" class="btn btn-primary btn-block">Filter</button>
        </div>
    </div>

    <hr>

    <div id="report-summary" class="tw-mb-6">
        <h4>Total Sale: <span id="total_sale">0.00</span></h4>
        <h4>Total Purchase: <span id="total_purchase">0.00</span></h4>
        <h4>Office Expense: <span id="office_expense">0.00</span></h4>
        <h4><strong>Net Profit: <span id="net_profit">0.00</span></strong></h4>
    </div>

    <div class="table-responsive">
        <table class="table table-bordered table-striped" id="profit_loss_table">
            <thead class="bg-light">
                <tr>
                    <th>#</th>
                    <th>Partner</th>
                    <th>Partner Percentage</th>
                    <th>Share Amount</th>
                    <th>Personal Expense</th>
                    <th>Final Amount</th>
                </tr>
            </thead>
            <tbody></tbody>
        </table>
    </div>

    <?php echo $__env->renderComponent(); ?>
</section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
<script>
$(function () {
    $('#from_date, #to_date').datepicker({
        format: 'yyyy-mm-dd',
        autoclose: true,
        todayHighlight: true
    });

    $('#filter_btn').click(loadReport);

    function loadReport() {
        $.ajax({
            url: '<?php echo e(route("profit-loss.data"), false); ?>',
            data: {
                from: $('#from_date').val(),
                to: $('#to_date').val()
            },
            success: function (res) {
                // Summary section
                $('#total_sale').text(res.total_sales);
                $('#total_purchase').text(res.total_purchase);
                $('#office_expense').text(res.office_expense);
                $('#net_profit').text(res.net_profit);

                // Partner table
                let tbody = '';
                res.data.forEach((row, i) => {
                    tbody += `<tr>
                        <td>${i + 1}</td>
                        <td>${row.partner}</td>
                        <td>${row.percentage}</td>
                        <td>${row.share_amount}</td>
                        <td>${row.personal_expense}</td>
                        <td><strong>${row.final_amount}</strong></td>
                    </tr>`;
                });
                $('#profit_loss_table tbody').html(tbody);
            },
            error: function (xhr) {
                alert('Error loading report data');
                console.error(xhr.responseText);
            }
        });
    }

    // Initial load
    loadReport();
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/devyarprojects/posulimate.devyarprojects.com/resources/views/dailybook/profit_loss_report.blade.php ENDPATH**/ ?>