@extends('layouts.app')
@section('title', 'Ledger Types')

@section('content')
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-2xl tw-font-bold">Ledger Types</h1>
</section>

<section class="content">
    @component('components.widget', ['class' => 'box-primary', 'title' => 'Ledger Types List'])
        
        @if(session('success'))
            <div class="alert alert-success">{{ session('success') }}</div>
        @endif

        <div class="mb-3">
            <a href="{{ route('ledger-types.create') }}" class="btn btn-primary">
                <i class="fa fa-plus"></i> Add New Ledger Type
            </a>
        </div>

        <div class="table-responsive">
            <table class="table table-bordered table-striped">
                <thead class="bg-light">
                    <tr>
                        <th>Name</th>
                        <th>Description</th>
                        <th>Active</th>
                        <th>Subcategories</th>
                        <th class="text-center">Actions</th>
                    </tr>
                </thead>
                <tbody>
                @forelse($types as $t)
                    <tr>
                        <td>{{ $t->name }}</td>
                        <td>{{ \Illuminate\Support\Str::limit($t->description, 80) }}</td>
                        <td>
                            <span class="badge {{ $t->is_active ? 'badge-success' : 'badge-danger' }}">
                                {{ $t->is_active ? 'Active' : 'Inactive' }}
                            </span>
                        </td>
                        <td>{{ $t->subcategories()->count() }}</td>
                        <td class="text-center">
                            <a href="{{ route('ledger-types.edit', $t->id) }}" 
                               class="btn btn-sm btn-outline-primary">
                                <i class="fa fa-edit"></i> Edit
                            </a>

                            <form action="{{ route('ledger-types.destroy', $t->id) }}" 
                                  method="POST" class="d-inline"
                                  onsubmit="return confirm('Delete this ledger type? This will also remove its subcategories.')">
                                @csrf
                                @method('DELETE')
                                <button class="btn btn-sm btn-danger">
                                    <i class="fa fa-trash"></i> Delete
                                </button>
                            </form>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="5" class="text-center text-muted">No ledger types found.</td>
                    </tr>
                @endforelse
                </tbody>
            </table>
        </div>

        <div class="mt-3">
            {{ $types->links() }}
        </div>
    @endcomponent
</section>
@endsection
