@extends('layouts.app')
@section('title', 'Edit Ledger Type')

@section('content')
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-2xl tw-font-bold">Edit Ledger Type</h1>
</section>

<section class="content">
    @component('components.widget', ['class' => 'box-primary', 'title' => 'Update Ledger Type'])
        <form action="{{ route('ledger-types.update', $type->id) }}" method="POST">
            @csrf
            @method('PUT')

            <div class="row">
                <!-- Name -->
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="name">Name:*</label>
                        {!! Form::text('name', old('name', $type->name), [
                            'class' => 'form-control',
                            'required',
                            'placeholder' => 'Enter Ledger Type Name',
                            'oninvalid'=> "this.setCustomValidity('Please enter ledger type name')",
                            'oninput'  => "this.setCustomValidity('')"
                        ]) !!}
                        @error('name') <span class="text-danger">{{ $message }}</span> @enderror
                    </div>
                </div>

                <!-- Description -->
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="description">Description</label>
                        {!! Form::textarea('description', old('description', $type->description), [
                            'class' => 'form-control',
                            'rows' => 2,
                            'placeholder' => 'Optional description'
                        ]) !!}
                        @error('description') <span class="text-danger">{{ $message }}</span> @enderror
                    </div>
                </div>

                <!-- Active Checkbox -->
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="is_active">Status</label><br>
                        <input type="checkbox" id="is_active" name="is_active" value="1" 
                               {{ old('is_active', $type->is_active) ? 'checked' : '' }}>
                        <label for="is_active"> Active</label>
                    </div>
                </div>

                <!-- Submit -->
                <div class="col-md-12">
                    <button type="submit" class="btn btn-primary">Update</button>
                    <a href="{{ route('ledger-types.index') }}" class="btn btn-default">Cancel</a>
                </div>
            </div>
        </form>
    @endcomponent
</section>
@endsection
