@extends('layouts.app')
@section('title', 'Add Ledger Type')

@section('content')
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-2xl tw-font-bold">Add Ledger Type</h1>
</section>

<section class="content">
    @component('components.widget', ['class' => 'box-primary', 'title' => 'New Ledger Type'])
        <form action="{{ route('ledger-types.store') }}" method="POST">
            @csrf

            <div class="row">
                <!-- Name -->
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="name">Name:*</label>
                        {!! Form::text('name', old('name'), [
                            'class' => 'form-control',
                            'required',
                            'placeholder' => 'Enter Ledger Type Name',
                            'oninvalid'=> "this.setCustomValidity('Please enter ledger type name')",
                            'oninput'  => "this.setCustomValidity('')"
                        ]) !!}
                        @error('name') <span class="text-danger">{{ $message }}</span> @enderror
                    </div>
                </div>

                <!-- Description -->
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="description">Description</label>
                        {!! Form::textarea('description', old('description'), [
                            'class' => 'form-control',
                            'rows' => 2,
                            'placeholder' => 'Optional description'
                        ]) !!}
                        @error('description') <span class="text-danger">{{ $message }}</span> @enderror
                    </div>
                </div>

                <!-- Active Checkbox -->
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="is_active">Status</label><br>
                        <input type="checkbox" id="is_active" name="is_active" value="1" checked>
                        <label for="is_active"> Active</label>
                    </div>
                </div>

                <!-- Submit -->
                <div class="col-md-12">
                    <button type="submit" class="btn btn-primary">Save</button>
                    <a href="{{ route('ledger-types.index') }}" class="btn btn-default">Cancel</a>
                </div>
            </div>
        </form>
    @endcomponent
</section>
@endsection
