@extends('layouts.app')
@section('title', 'Ledger Subcategories')

@section('content')
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-2xl tw-font-bold">Ledger Subcategories</h1>
</section>

<section class="content">
    @component('components.widget', ['class' => 'box-primary', 'title' => 'Ledger Subcategories List'])

        @if(session('success'))
            <div class="alert alert-success">{{ session('success') }}</div>
        @endif

        <div class="mb-3">
            <a href="{{ route('ledger-subcategories.create') }}" class="btn btn-primary">
                <i class="fa fa-plus"></i> Add New Subcategory
            </a>
        </div>

        <div class="table-responsive">
            <table class="table table-bordered table-striped">
                <thead class="bg-light">
                    <tr>
                        <th>Name</th>
                        <th>Ledger Type</th>
                        <th>Description</th>
                        <th>Active</th>
                        <th class="text-center">Actions</th>
                    </tr>
                </thead>
                <tbody>
                @forelse($subcategories as $sub)
                    <tr>
                        <td>{{ $sub->name }}</td>
                        <td>{{ $sub->ledgerType->name ?? '-' }}</td>
                        <td>{{ \Illuminate\Support\Str::limit($sub->description, 80) }}</td>
                        <td>
                            <span class="badge {{ $sub->is_active ? 'badge-success' : 'badge-danger' }}">
                                {{ $sub->is_active ? 'Active' : 'Inactive' }}
                            </span>
                        </td>
                        <td class="text-center">
                            <a href="{{ route('ledger-subcategories.edit', $sub->id) }}" 
                               class="btn btn-sm btn-outline-primary">
                                <i class="fa fa-edit"></i> Edit
                            </a>

                            <form action="{{ route('ledger-subcategories.destroy', $sub->id) }}" 
                                  method="POST" class="d-inline"
                                  onsubmit="return confirm('Delete this subcategory?')">
                                @csrf
                                @method('DELETE')
                                <button class="btn btn-sm btn-danger">
                                    <i class="fa fa-trash"></i> Delete
                                </button>
                            </form>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="5" class="text-center text-muted">No subcategories found.</td>
                    </tr>
                @endforelse
                </tbody>
            </table>
        </div>

        <div class="mt-3">
            {{ $subcategories->links() }}
        </div>
    @endcomponent
</section>
@endsection
