@extends('layouts.app')
@section('title', 'Add Ledger Subcategory')

@section('content')
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-2xl tw-font-bold">Add New Subcategory</h1>
</section>

<section class="content">
    @component('components.widget', ['class' => 'box-primary', 'title' => 'Create Subcategory'])

        <form action="{{ route('ledger-subcategories.store') }}" method="POST">
            @csrf

            <div class="form-group">
                <label>Subcategory Name <span class="text-danger">*</span></label>
                <input type="text" name="name" class="form-control @error('name') is-invalid @enderror"
                       value="{{ old('name') }}" required>
                @error('name') <div class="invalid-feedback">{{ $message }}</div> @enderror
            </div>

            <div class="form-group">
                <label>Ledger Type <span class="text-danger">*</span></label>
                <select name="ledger_type_id" class="form-control @error('ledger_type_id') is-invalid @enderror" required>
                    <option value="">-- Select Ledger Type --</option>
                    @foreach($ledgerTypes as $type)
                        <option value="{{ $type->id }}" {{ old('ledger_type_id') == $type->id ? 'selected' : '' }}>
                            {{ $type->name }}
                        </option>
                    @endforeach
                </select>
                @error('ledger_type_id') <div class="invalid-feedback">{{ $message }}</div> @enderror
            </div>

            <div class="form-group">
                <label>Description</label>
                <textarea name="description" class="form-control">{{ old('description') }}</textarea>
            </div>

            <div class="form-check mb-3">
                <input type="checkbox" class="form-check-input" id="is_active" name="is_active"
                       {{ old('is_active', true) ? 'checked' : '' }}>
                <label class="form-check-label" for="is_active">Active</label>
            </div>

            <button type="submit" class="btn btn-success"><i class="fa fa-save"></i> Save</button>
            <a href="{{ route('ledger-subcategories.index') }}" class="btn btn-secondary">Cancel</a>
        </form>

    @endcomponent
</section>
@endsection
