@extends('layouts.app')
@section('title', 'Daily Book Report')

@section('content')
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-2xl tw-font-bold">Daily Book Report</h1>
</section>

<section class="content">
    @component('components.widget', ['class' => 'box-primary', 'title' => 'Daily Book By Date'])
        
        <!-- Date Filter -->


        <div class="row tw-mb-5">
            <div class="col-md-3">
                <label>Select Date : </label>
            </div>
            <div class="col-md-4">
                <input type="text" id="filter_date" 
                       class="form-control" 
                       value="{{ $date }}" 
                       autocomplete="off">
            </div>
        </div>

        <hr>
        <!-- Table -->
        <div class="table-responsive">
            <table class="table table-bordered table-striped" id="dailybook_table">
                <thead class="bg-light">
                    <tr>
                        <th>#</th>
                        <th>Ledger Type</th>
                        <th>Ledger Subcategory</th>
                        <th>Details</th>
                        <th>Debit</th>
                        <th>Credit</th>
                        <th>Source</th>
                    </tr>
                </thead>
            </table>
        </div>
    @endcomponent
</section>
@endsection

@section('javascript')
<script>
$(function () {
    // Init datepicker directly on the input
    $('#filter_date').datepicker({
        format: 'yyyy-mm-dd',
        autoclose: true,
        todayHighlight: true
    }).on('changeDate', function () {
        $('#dailybook_table').DataTable().ajax.reload();
    });

    // Init DataTable
    $('#dailybook_table').DataTable({
        processing: true,
        serverSide: true,
        ajax: {
            url: '{{ route("dailybook.data") }}',
            data: function (d) {
                d.date = $('#filter_date').val(); // pass selected date
            }
        },
        columns: [
            { data: 'sr_no', name: 'sr_no', orderable: false, searchable: false },
            { data: 'ledger_type', name: 'ledgerType.name' },
            { data: 'ledger_subcategory', name: 'ledgerSubcategory.name' },
            { data: 'detail', name: 'detail' },
            { data: 'debit', name: 'debit' },
            { data: 'credit', name: 'credit' },
            { data: 'source', name: 'source' }
        ]
    });
});
</script>
@endsection
