@extends('layouts.app')
@section('title', 'Add Daily Book Entry')

@section('content')
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-2xl tw-font-bold">Add Daily Book Entry</h1>
</section>

<section class="content">
    @component('components.widget', ['class' => 'box-primary', 'title' => 'New Entry'])
        <form method="POST" action="{{ route('dailybook.store') }}">
            @csrf

            <div class="row">

                <!-- Date -->
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="entry_date">Date:*</label>
                        {!! Form::date('entry_date', old('entry_date', now()->toDateString()), [
                            'class' => 'form-control',
                            'required'
                        ]) !!}
                        @error('entry_date') <span class="text-danger">{{ $message }}</span> @enderror
                    </div>
                </div>

                

                <!-- Type -->
				<div class="col-md-3">
				    <div class="form-group">
				        <label for="type">Type:*</label>
				        {!! Form::select('type', [
				            
				            'receipt'  => 'Receipt',
				            'payment'  => 'Payment',
				            'expense'  => 'Expense'
				        ], old('type'), [
				            'class'    => 'form-control select2',
				            'id'       => 'type',				            
                            'placeholder' => 'Please Select Type from list',
				            'required',
				            'oninvalid'=> "this.setCustomValidity('Please select type')",
				            'oninput'  => "this.setCustomValidity('')"
				        ]) !!}
				        @error('type') <span class="text-danger">{{ $message }}</span> @enderror
				    </div>
				</div>



                <!-- Mode (Ledger) -->
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="mode">Mode:*</label>
                        {!! Form::select('mode', $moneyLedgers, old('mode'), [
				            'class'    => 'form-control select2',
				            'id'       => 'mode',
                            'placeholder' => 'Please Select Mode from list',
                            'required',
				            'oninvalid'=> "this.setCustomValidity('Please select mode')",
				            'oninput'  => "this.setCustomValidity('')"
                        ]) !!}
                        @error('mode') <span class="text-danger">{{ $message }}</span> @enderror
                    </div>
                </div>

                <!-- Amount -->
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="amount">Amount:*</label>
                        {!! Form::number('amount', old('amount'), [
                            'class' => 'form-control',
                            'step' => '0.01',
                            'min' => '0.01',
                            'required'
                        ]) !!}
                        @error('amount') <span class="text-danger">{{ $message }}</span> @enderror
                    </div>
                </div>

                <!-- Customer -->
                <div class="col-md-6 type-field type-receipt d-none">
                    <div class="form-group">
                        <label for="customer_id">Customer:*</label>
                        {!! Form::select('customer_id', $customers, old('customer_id'), [
                            'class' => 'form-control select2',
                            'placeholder' => 'Please Select'
                        ]) !!}
                        @error('customer_id') <span class="text-danger">{{ $message }}</span> @enderror
                    </div>
                </div>

                <!-- Supplier -->
                <div class="col-md-6 type-field type-payment d-none">
                    <div class="form-group">
                        <label for="supplier_id">Supplier:*</label>
                        {!! Form::select('supplier_id', $suppliers, old('supplier_id'), [
                            'class' => 'form-control select2',
                            'placeholder' => 'Please Select'
                        ]) !!}
                        @error('supplier_id') <span class="text-danger">{{ $message }}</span> @enderror
                    </div>
                </div>

                <!-- Expense Ledger -->
                <div class="col-md-6 type-field type-expense d-none">
                    <div class="form-group">
                        <label for="expense_ledger_id">Expense Category:*</label>
                        {!! Form::select('expense_ledger_id', $expenseLedgers, old('expense_ledger_id'), [
                            'class' => 'form-control select2',
                            'placeholder' => 'Please Select'
                        ]) !!}
                        @error('expense_ledger_id') <span class="text-danger">{{ $message }}</span> @enderror
                    </div>
                </div>

                <!-- Reference -->
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="reference">Reference No</label>
                        {!! Form::text('reference', old('reference'), ['class' => 'form-control']) !!}
                        @error('reference') <span class="text-danger">{{ $message }}</span> @enderror
                    </div>
                </div>

                <!-- Notes -->
                <div class="col-md-8">
                    <div class="form-group">
                        <label for="notes">Note</label>
                        {!! Form::textarea('notes', old('notes'), ['class' => 'form-control', 'rows' => 2]) !!}
                        @error('notes') <span class="text-danger">{{ $message }}</span> @enderror
                    </div>
                </div>

                <!-- Submit -->
                <div class="col-md-12">
                    <button type="submit" class="btn btn-primary">Save</button>
                    <a href="{{ route('dailybook.index') }}" class="btn btn-default">Cancel</a>
                </div>
            </div>
        </form>
    @endcomponent
</section>
@endsection

@section('javascript')
<script>
$(document).ready(function () {
    const typeSelect = $('#type');
    function toggleFields() {
        $('.type-field').addClass('d-none');
        const val = typeSelect.val();
        if (val === 'receipt') $('.type-receipt').removeClass('d-none');
        if (val === 'payment') $('.type-payment').removeClass('d-none');
        if (val === 'expense') $('.type-expense').removeClass('d-none');
    }
    typeSelect.change(toggleFields);
    toggleFields();
});
</script>
@endsection
