@extends('layouts.app')
@section('title', __('Cash In Hand'))

@section('content')

<!-- Content Header -->
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">@lang('Cash In Hand')
        <small class="tw-text-sm md:tw-text-base tw-text-gray-700 tw-font-semibold">@lang('Track and manage your cash balances')</small>
    </h1>
</section>

<!-- Main Content -->
<section class="content">

    @component('components.widget', ['class' => 'box-primary', 'title' => __( 'Cash In Hand Entries' )])
        @slot('tool')
            <div class="box-tools">
                <a href="{{ route('cashinhand.create') }}" 
                   class="tw-dw-btn tw-bg-gradient-to-r tw-from-blue-600 tw-to-indigo-500 tw-font-bold tw-text-white tw-border-none tw-rounded-full pull-right tw-mb-2">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" 
                         stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                         class="icon icon-tabler icons-tabler-outline icon-tabler-plus">
                        <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                        <path d="M12 5v14" />
                        <path d="M5 12h14" />
                    </svg> @lang('messages.add')
                </a>
            </div>
        @endslot

        <!-- Summary Cards -->
        <div class="row tw-mb-5">
            <div class="col-md-4">
                <div class="info-box bg-green">
                    <span class="info-box-icon"><i class="fas fa-wallet"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Total Cash In</span>
                        <span class="info-box-number">{{ number_format($totals['receipt'] ?? 0,2) }}</span>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="info-box bg-red">
                    <span class="info-box-icon"><i class="fas fa-money-bill-wave"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Total Cash Out</span>
                        <span class="info-box-number">{{ number_format($totals['payment'] ?? 0,2) }}</span>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="info-box bg-yellow">
                    <span class="info-box-icon"><i class="fas fa-balance-scale"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Net Balance</span>
                        <span class="info-box-number">{{ number_format($totals['balance'] ?? 0,2) }}</span>
                    </div>
                </div>
            </div>
        </div>


        <!-- DataTable -->
        <div class="table-responsive">
            <table class="table table-bordered table-striped" id="cashinhand_table">
                <thead>
                    <tr>
                        <th>Sr No. #</th>
                        <th>Date</th>
                        <th>Type</th>
                        <th>Ledger</th>
                        <th>Details</th>
                        <th>Dr / Cr</th>
                        <th>Amount</th>
                        <th>Balance</th>
                        <th class="text-center">Actions</th>
                    </tr>
                </thead>
            </table>
        </div>
    @endcomponent

</section>
@endsection

@section('javascript')
<script>
$(document).ready(function () {
    $('#cashinhand_table').DataTable({
    processing: true,
    serverSide: true,
    ajax: '{{ route("cashinhand.data") }}',
    columns: [
        { data: 'sr_no', name: 'sr_no', orderable: false, searchable: false }, // serial number
        { data: 'entry_date', name: 'entry_date' },
        { data: 'ledger_type', name: 'ledgerType.name' },
        { data: 'ledger_subcategory', name: 'ledgerSubcategory.name' },
        { data: 'detail', name: 'detail' },
        { data: 'dr_cr', name: 'dr_cr' },
        { data: 'amount', name: 'amount' },
        { data: 'balance', name: 'balance' },
        // { data: 'created_by', name: 'creator.name' },
        { data: 'action', name: 'action', orderable: false, searchable: false },
    ]
});

    @if(session('success'))
        toastr.success("{{ session('success') }}");
    @endif
});
</script>
@endsection
