@extends('layouts.app')
@section('title', 'Edit Cash in Hand Entry')

@section('content')
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-2xl tw-font-bold">Edit Cash in Hand Entry</h1>
</section>

<section class="content">
    @component('components.widget', ['class' => 'box-primary', 'title' => 'Update Cash in Hand Entry'])
        <form method="POST" action="{{ route('cashinhand.update', $entry->id) }}">
            @csrf
            @method('PUT')

            <div class="row">
                <!-- Date -->
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="entry_date">Date:*</label>
                        <div class="input-group">
                            <span class="input-group-text"><i class="bi bi-calendar-date"></i></span>
                            {!! Form::date('entry_date', old('entry_date', $entry->entry_date->format('Y-m-d')), [
                                'class' => 'form-control',
                                'id' => 'entry_date',
                                'required'
                            ]) !!}
                        </div>
                        @error('entry_date') 
                            <span class="text-danger">{{ $message }}</span> 
                        @enderror
                    </div>
                </div>

                <!-- Ledger Type -->
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="ledger_type_id">Ledger Type:*</label>
                        <select name="ledger_type_id" id="ledger_type_id"
                                class="form-control select2 @error('ledger_type_id') is-invalid @enderror" required>
                            <option value="">-- Select Type --</option>
                            @foreach($ledgerTypes as $type)
                                <option value="{{ $type->id }}" 
                                    {{ old('ledger_type_id', $entry->ledger_type_id) == $type->id ? 'selected' : '' }}>
                                    {{ $type->name }}
                                </option>
                            @endforeach
                        </select>
                        @error('ledger_type_id') <span class="text-danger">{{ $message }}</span> @enderror
                    </div>
                </div>

                <!-- Ledger Subcategory -->
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="ledger_subcategory_id">Ledger Subcategory:*</label>
                        <select name="ledger_subcategory_id" id="ledger_subcategory_id"
                                class="form-control select2 @error('ledger_subcategory_id') is-invalid @enderror" required>
                            <option value="">-- Select Subcategory --</option>
                            @foreach($subcategories as $sc)
                                <option value="{{ $sc->id }}" 
                                    {{ old('ledger_subcategory_id', $entry->ledger_subcategory_id) == $sc->id ? 'selected' : '' }}>
                                    {{ $sc->name }}
                                </option>
                            @endforeach
                        </select>
                        @error('ledger_subcategory_id') <span class="text-danger">{{ $message }}</span> @enderror
                    </div>
                </div>
            </div>

            <div class="row">
                <!-- Amount -->
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="amount">Amount:*</label>
                        {!! Form::number('amount', old('amount', $entry->amount), [
                            'class' => 'form-control',
                            'step'  => '0.01',
                            'required',
                            'placeholder' => 'Enter amount'
                        ]) !!}
                        @error('amount') <span class="text-danger">{{ $message }}</span> @enderror
                    </div>
                </div>

                <!-- Detail -->
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="detail">Detail:*</label>
                        {!! Form::text('detail', old('detail', $entry->detail), [
                            'class' => 'form-control',
                            'required',
                            'placeholder' => 'Enter detail'
                        ]) !!}
                        @error('detail') <span class="text-danger">{{ $message }}</span> @enderror
                    </div>
                </div>

                <!-- Dr/Cr -->
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="dr_cr">Dr / Cr:*</label>
                        <div class="d-flex align-items-center">
                            <div class="form-check me-3">
                                <input type="radio" name="dr_cr" id="dr" value="dr" 
                                    class="form-check-input"
                                    {{ old('dr_cr', $entry->dr_cr) == 'dr' ? 'checked' : '' }} required>
                                <label class="form-check-label" for="dr">Debit</label>
                            </div>

                            <div class="form-check">
                                <input type="radio" name="dr_cr" id="cr" value="cr" 
                                    class="form-check-input"
                                    {{ old('dr_cr', $entry->dr_cr) == 'cr' ? 'checked' : '' }}>
                                <label class="form-check-label" for="cr">Credit</label>
                            </div>
                        </div>
                        @error('dr_cr') <span class="text-danger">{{ $message }}</span> @enderror
                    </div>
                </div>
            </div>

            <!-- Submit -->
            <div class="col-md-12 mt-3">
                <button type="submit" class="btn btn-primary">Update</button>
                <a href="{{ route('cashinhand.index') }}" class="btn btn-default">Cancel</a>
            </div>
        </form>
    @endcomponent
</section>
@endsection

@section('javascript')
<script>
    $(document).ready(function () {
        let typeId = $('#ledger_type_id').val();
        let subcatDropdown = $('#ledger_subcategory_id');

        function loadSubcategories(typeId, selectedId = null) {
            if (typeId) {
                let url = "{{ url('/ledger-types') }}/" + typeId + "/subcategories";
                fetch(url)
                    .then(res => res.json())
                    .then(data => {
                        let options = '<option value="">-- Please Select Subcategory From List --</option>';
                        data.forEach(sc => {
                            options += `<option value="${sc.id}" ${selectedId == sc.id ? 'selected' : ''}>${sc.name}</option>`;
                        });
                        subcatDropdown.html(options);
                    });
            } else {
                subcatDropdown.html('<option value="">-- Select Subcategory --</option>');
            }
        }

        // Load subcategories on page load
        loadSubcategories(typeId, "{{ old('ledger_subcategory_id', $entry->ledger_subcategory_id) }}");

        // Reload subcategories on ledger type change
        $('#ledger_type_id').on('change', function () {
            loadSubcategories($(this).val());
        });
    });
</script>
@endsection
