@extends('layouts.app')
@section('title', __('Business Partners'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">@lang('Business Partners')
        <small class="tw-text-sm md:tw-text-base tw-text-gray-700 tw-font-semibold">@lang('Manage Your Business Partners')</small>
    </h1>
</section>


<!-- Main content -->
<section class="content">
    @component('components.widget', ['class' => 'box-primary', 'title' => __( 'All Your Business Partners' )])
        @slot('tool')
            <div class="box-tools">
                <button class="tw-dw-btn tw-bg-gradient-to-r tw-from-indigo-600 tw-to-blue-500 tw-font-bold tw-text-white tw-border-none tw-rounded-full pull-right tw-mb-2 btn-modal"
                    data-href="{{ action([\App\Http\Controllers\BusinessPartnerController::class, 'create']) }}" 
                    data-container=".partner_add_modal">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor"
                        stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                        class="icon icon-tabler icons-tabler-outline icon-tabler-plus">
                        <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                        <path d="M12 5l0 14" />
                        <path d="M5 12l14 0" />
                    </svg> @lang('messages.add')
                </button>
            </div>
        @endslot

        <div class="table-responsive">
            <table class="table table-bordered table-striped" id="business_Partners_table">
                <thead>
                    <tr>
                        <th>@lang('Business Partner Name')</th>
                        <th>@lang('Business Partner Email')</th>
                        <th>@lang('Business Partner Phone')</th>
                        <th>@lang('Business Partner Address')</th>
                        <th>@lang('Business Partner Percentage')</th>
                        <!-- <th>@lang('Business Partner City')</th>
                        <th>@lang('Business Partner Country')</th> -->
                        <th>@lang('Business Partner Status')</th>
                        <th>@lang('messages.action')</th>
                    </tr>
                </thead>
            </table>
        </div>
    @endcomponent

    <div class="modal fade partner_add_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel"></div>
    <div class="modal fade partner_edit_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel"></div>
</section>
<!-- /.content -->

@endsection

@section('javascript')
<script>
$(document).ready(function () {
    $('#business_Partners_table').DataTable({
        processing: true,
        serverSide: true,
        // paging: true,          // keep pagination
        // searching: true,       // keep search box
        // lengthChange: false,   // hides "Show X entries" dropdown
        // dom: 't<"bottom"p>',   // removes export buttons, keeps only table + pagination
        ajax: '{{ action([\App\Http\Controllers\BusinessPartnerController::class, "index"]) }}',
        columns: [
            { data: 'name', name: 'name' },
            { data: 'email', name: 'email' },
            { data: 'phone', name: 'phone' },
            { data: 'address', name: 'address' },
            { data: 'percentage', name: 'percentage' },
            { data: 'status', name: 'status' }, // make sure you added `status` in DB + model
            { data: 'action', name: 'action', orderable: false, searchable: false }
        ]
    });

    $(document).on('click', '.btn-modal', function(e) {
        e.preventDefault();
        let container = $(this).data('container');
        let href = $(this).data('href');
        $.ajax({
            url: href,
            type: 'GET',
            success: function(result) {
                $(container).html(result);
                $(container).modal('show');
            }
        });
    });

    // Toastr messages
    @if(session('success'))
        toastr.success("{{ session('success') }}");
    @endif

    @if(session('error'))
        toastr.error("{{ session('error') }}");
    @endif

    $(document).on('click', '.delete_partner_button', function(e) {
        e.preventDefault();
        let url = $(this).data('href');

        if (confirm("Are you sure you want to delete this partner?")) {
            $.ajax({
                url: url,
                type: 'DELETE',
                data: {
                    _token: '{{ csrf_token() }}' // Laravel CSRF token
                },
                success: function(response) {
                    toastr.success("Partner deleted successfully!");
                    $('#business_Partners_table').DataTable().ajax.reload(); // refresh DataTable
                },
                error: function(xhr) {
                    toastr.error("Something went wrong. Please try again!");
                }
            });
        }
        });

});
</script>
@endsection

