<div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">

        
        {!! Form::open(['url' => action([\App\Http\Controllers\BusinessPartnerController::class, 'update'], [$partner->id]), 'method' => 'PUT', 'id' => 'business_location_add_form' ]) !!}

        {!! Form::hidden('hidden_id', $partner->id, ['id' => 'hidden_id']); !!}
        <div class="modal-header">
            <h4 class="modal-title">Edit Business Partner</h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>

        <div class="modal-body">
            <div class="row">

                <!-- Business Partner Name -->
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('name', 'Business Partner Name:*') !!}
                        {!! Form::text('name', $partner->name, ['class' => 'form-control', 'required', 'placeholder' => 'Business Partner Name']) !!}
                    </div>
                </div>

                <!-- Phone -->
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('phone', 'Phone:') !!}
                        {!! Form::text('phone', $partner->phone, ['class' => 'form-control', 'placeholder' => 'Phone number']) !!}
                    </div>
                </div>

                <!-- Email -->
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('email', 'Email:') !!}
                        {!! Form::email('email', $partner->email, ['class' => 'form-control', 'placeholder' => 'Email address']) !!}
                    </div>
                </div>

                <!-- Address -->
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('address', 'Address:') !!}
                        {!! Form::text('address', $partner->address, ['class' => 'form-control', 'placeholder' => 'Full address']) !!}
                    </div>
                </div>

                <!-- Business Partner Percentage -->
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('percentage', 'Business Partner Percentage (%):*') !!}
                        {!! Form::number('percentage', $partner->percentage, ['class' => 'form-control', 'required', 'placeholder' => 'Percentage', 'min' => 10, 'max' => 90]) !!}
                    </div>
                </div>

                <!-- Status -->
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('status', 'Status:') !!}
                        {!! Form::select('status', ['Active' => 'Active', 'Inactive' => 'Inactive'], $partner->status, ['class' => 'form-control']) !!}

                    </div>
                </div>

                <!-- Notes -->
                <div class="col-sm-12">
                    <div class="form-group">
                        {!! Form::label('details', 'Details / Notes:') !!}
                        {!! Form::textarea('details', $partner->details, ['class' => 'form-control', 'rows' => 3, 'placeholder' => 'Additional details about partner']) !!}
                    </div>
                </div>

            </div>
        </div>

        <div class="modal-footer">
            <button type="submit" class="btn btn-primary">Save</button>
            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
        </div>

        {!! Form::close() !!}
    </div>
</div>
