<div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">

        {!! Form::open(['url' => action([\App\Http\Controllers\BusinessPartnerController::class, 'store']), 'method' => 'post', 'id' => 'business_partner_add_form' ]) !!}

        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
            <h4 class="modal-title">@lang('Add Business Partner')</h4>
        </div>

        <div class="modal-body">
            <div class="row">

                <!-- Partner Name -->
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('name', __( 'Business Partner Name' ) . ':*') !!}
                        {!! Form::text('name', null, ['class' => 'form-control', 'required', 'placeholder' => __( 'Business Partner Name' ) ]); !!}
                    </div>
                </div>

                <!-- Phone -->
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('phone', __( 'Phone' ) . ':') !!}
                        {!! Form::text('phone', null, ['class' => 'form-control', 'placeholder' => __( 'Phone number' ) ]); !!}
                    </div>
                </div>

                <div class="clearfix"></div>

                <!-- Email -->
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('email', __( 'Email' ) . ':') !!}
                        {!! Form::email('email', null, ['class' => 'form-control', 'placeholder' => __( 'Email address' ) ]); !!}
                    </div>
                </div>

                <!-- Address -->
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('address', __( 'Address' ) . ':') !!}
                        {!! Form::text('address', null, ['class' => 'form-control', 'placeholder' => __( 'Full address' ) ]); !!}
                    </div>
                </div>

                <div class="clearfix"></div>

                <!-- Percentage -->
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('percentage', __( 'Business Partner Percentage (%)' ) . ':*') !!}
                        {!! Form::number('percentage', null, ['class' => 'form-control', 'step' => '0.01', 'min' => '0', 'max' => '100', 'required', 'placeholder' => __( 'Percentage' ) ]); !!}
                    </div>
                </div>

                <!-- Status -->
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('status', __( 'Status' ) . ':') !!}
                        {!! Form::select('status', ['active' => __('Active'), 'inactive' => __('Inactive')], 'active', ['class' => 'form-control']); !!}
                    </div>
                </div>

                <div class="clearfix"></div>

                <!-- Details -->
                <div class="col-sm-12">
                    <div class="form-group">
                        {!! Form::label('details', __( 'Details / Notes' ) . ':') !!}
                        {!! Form::textarea('details', null, ['class' => 'form-control', 'rows' => 3, 'placeholder' => __( 'Additional details about partner' ) ]); !!}
                    </div>
                </div>

            </div>
        </div>

        <div class="modal-footer">
            <button type="submit" class="tw-dw-btn tw-dw-btn-primary tw-text-white">@lang( 'messages.save' )</button>
            <button type="button" class="tw-dw-btn tw-dw-btn-neutral tw-text-white" data-dismiss="modal">@lang( 'messages.close' )</button>
        </div>

        {!! Form::close() !!}

    </div><!-- /.modal-content -->
</div><!-- /.modal-dialog -->
