<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Ledger;

class LedgerSeeder extends Seeder
{
    public function run()
    {
        $baseLedgers = [
            ['name' => 'Cash Ledger',    'type' => 'cash'],
            ['name' => 'Bank Ledger',    'type' => 'bank'],
            ['name' => 'Customer Ledger','type' => 'customer'],
            ['name' => 'Supplier Ledger','type' => 'supplier'],
            ['name' => 'Expense Ledger', 'type' => 'expense'],
        ];

        foreach ($baseLedgers as $ledger) {
            Ledger::firstOrCreate(['type' => $ledger['type']], $ledger);
        }
    }
}
