<?php

namespace App\Services;

use Illuminate\Support\Facades\Http;

class FBRInvoiceService
{
    protected $endpoint;
    // protected $endpoint = 'https://gw.fbr.gov.pk/di_data/v1/di/postinvoicedata_sb'; // or Sandbox if testing
    protected $authorizationToken;

    public function __construct()
    {
        $this->endpoint = config('services.fbr.api_url'); // Store in config/services.php
        $this->authorizationToken = config('services.fbr.token'); // Store in config/services.php
    }


    public function sendInvoice($payload)
    {
        try {
            // Convert payload to raw JSON
            $jsonPayload = json_encode($payload, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);

            $response = Http::withHeaders([
                'Content-Type' => 'application/json',
                'Authorization' => 'Bearer ' . $this->authorizationToken,
                'Accept' => '*/*',
                'Accept-Encoding' => 'gzip, deflate, br',
                'Connection' => 'keep-alive',
            ])
            ->withOptions([
                'verify' => false,
                'timeout' => 30,
            ])
            ->withBody($jsonPayload, 'application/json')
            ->post($this->endpoint);

            if ($response->successful()) {
                $responseData = $response->json();
                if($responseData['validationResponse']['status'] == "Valid" && $responseData['validationResponse']['error'] == ""){
                    return [
                        'success' => true,
                        'raw_response' => $responseData
                    ];
                } else {
                    return [
                        'success' => false,
                        'raw_response' => $responseData
                    ];
                }
                /*dd($responseData['invoiceNumber']);
                
                return [
                    'success' => true,
                    'invoice_number' => $responseData['invoiceNumber'],
                    'dated' => $responseData['dated'],
                    'validation_response' => $responseData['validationResponse'],
                    'status_code' => $responseData['validationResponse']['statusCode'],
                    'status' => $responseData['validationResponse']['status']
                    //'raw_response' => $responseData
                ];*/
            } else {
                return [
                    'success' => false,
                    'error' => 'HTTP Error: ' . $response->status(),
                    'message' => $response->body()
                ];
            }

        } catch (\Exception $e) {
            return [
                'success' => false,
                'error' => 'Exception: ' . $e->getMessage()
            ];
        }
    }

    public function BackupsendInvoice(array $payload)
    {
        /*$response = Http::withHeaders([
            'Authorization' => 'Bearer ' . $this->authorizationToken,
            'Content-Type' => 'application/json',
        ])->post($this->endpoint, $payload);*/

        $http = Http::withHeaders([
            'Content-Type' => 'application/json',
            'Authorization' => 'Bearer ' . $this->authorizationToken, // ← use the dynamic token here
        ]);

        // Disable SSL verification only on localhost
        /*if (app()->environment('local')) { 
            $http = $http->withOptions(['verify' => false]); // disables SSL certificate check
        }*/

        $http = $http->withOptions(['verify' => false]); // disables SSL certificate check
        $response = $http->post($this->endpoint, $payload);

        dd([
            'status'     => $response->status(),
            'headers'    => $response->headers(),
            'raw_body'   => $response->body(),      // Raw text of response
            'decoded'    => json_decode($response->body(), true), // Try manual decode
        ]);

        dd($response);

        if ($response->successful()) {

            return $response->json(); // return decoded response
            

        } else {
            \Log::error("FBR API Error: " . $e->getMessage());
        }

        
    }
}
