<?php

namespace App\Services;

use App\DailyBookEntry;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;

class DailyBookService
{
    public static function addEntry(
        $date,
        $source,
        $ledgerTypeId,
        $subcategoryId,
        $detail,
        $debit,
        $credit,
        $referenceType,
        $referenceId
    ) {

        return DailyBookEntry::create([
            'entry_date'            => $date,
            'source'                => $source,
            'ledger_type_id'        => $ledgerTypeId,
            'ledger_subcategory_id' => $subcategoryId,
            'detail'                => $detail,
            'debit'                 => $debit,
            'credit'                => $credit,
            'reference_type'        => $referenceType,
            'reference_id'          => $referenceId,
        ]);
    }

    public static function updateOrAddEntry(
        $date,
        $source,
        $ledgerTypeId,
        $subcategoryId,
        $detail,
        $debit,
        $credit,
        $referenceType,
        $referenceId
    ) {
        return DailyBookEntry::updateOrCreate(
            [
                'reference_type' => $referenceType,
                'reference_id'   => $referenceId,
            ],
            [
                'entry_date'            => $date,
                'source'                => $source,
                'ledger_type_id'        => $ledgerTypeId,
                'ledger_subcategory_id' => $subcategoryId,
                'detail'                => $detail,
                'debit'                 => $debit,
                'credit'                => $credit,
            ]
        );
    }

    public static function deleteEntry($referenceType, $referenceId)
    {
        return DailyBookEntry::where('reference_type', $referenceType)
            ->where('reference_id', $referenceId)
            ->delete();
    }

    public static function updateEntry(
        $referenceType,
        $referenceId,
        $date,
        $source,
        $ledgerTypeId,
        $subcategoryId,
        $detail,
        $debit,
        $credit
    ) {
        return DailyBookEntry::where('reference_type', $referenceType)
            ->where('reference_id', $referenceId)
            ->update([
                'entry_date'            => $date,
                'source'                => $source,
                'ledger_type_id'        => $ledgerTypeId,
                'ledger_subcategory_id' => $subcategoryId,
                'detail'                => $detail,
                'debit'                 => $debit,
                'credit'                => $credit,
            ]);
    }


}