<?php
namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class LedgerType extends Model
{
    protected $table = 'ledger_types';

    protected $fillable = [
        'name',
        'slug',
        'description',
        'is_active'
    ];

    /**
     * Each LedgerType has many subcategories
     */
    /*public function subcategories(): HasMany
    {
        return $this->hasMany(LedgerSubcategory::class, 'ledger_type_id');
    }*/

    public function subcategories()
    {
        return $this->hasMany(LedgerSubcategory::class, 'ledger_type_id');
    }
}
