<?php
namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class LedgerSubcategory extends Model
{
    protected $table = 'ledger_subcategories';

    protected $fillable = [
        'ledger_type_id',
        'name',
        'description',
        'is_active'
    ];

    /**
     * Each Subcategory belongs to a LedgerType
     */
    public function ledgerType(): BelongsTo
    {
        return $this->belongsTo(LedgerType::class, 'ledger_type_id');
    }

    public function type()
    {
        return $this->belongsTo(LedgerType::class, 'ledger_type_id');
    }

    /*public function ledgers()
    {
        return $this->hasMany(Ledger::class, 'ledger_subcategory_id');
    }*/
    
}
