<?php
namespace App\Http\Controllers;

use App\LedgerType;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class LedgerTypeController extends Controller
{
    public function index()
    {
        $types = LedgerType::orderBy('name')->paginate(20);
        return view('ledger_types.index', compact('types'));
    }

    public function create()
    {
        return view('ledger_types.create');
    }

    public function store(Request $request)
    {	

        $data = $request->validate([
            'name' => 'required|string|max:150|unique:ledger_types,name',
            'description' => 'nullable|string',
            'is_active' => 'nullable|boolean'
        ]);

        $data['slug'] = Str::slug($data['name']);
        $data['is_active'] = $request->has('is_active') ? 1 : 0;

        LedgerType::create($data);

        return redirect()->route('ledger-types.index')->with('success', 'Ledger Type created.');
    }

    public function edit($id)
    {
        $type = LedgerType::findOrFail($id);
        return view('ledger_types.edit', compact('type'));
    }

    public function update(Request $request, $id)
    {
        $type = LedgerType::findOrFail($id);

        $data = $request->validate([
            'name' => 'required|string|max:150|unique:ledger_types,name,' . $id,
            'description' => 'nullable|string',
            'is_active' => 'nullable|boolean'
        ]);

        $data['slug'] = Str::slug($data['name']);
        $data['is_active'] = $request->has('is_active') ? 1 : 0;

        $type->update($data);

        return redirect()->route('ledger-types.index')->with('success','Ledger Type updated.');
    }

    public function destroy($id)
    {
        $type = LedgerType::findOrFail($id);
        $type->delete(); // cascade will remove subcategories per FK
        return back()->with('success','Ledger Type deleted.');
    }
}
