<?php

namespace App\Http\Controllers;

use App\DailyBookEntry;
use App\Ledger;
use App\LedgerType;
// use App\Customer;
use App\Contact;
use App\BusinessPartner;
// use App\Supplier;
// use App\Services\DailybookPoster;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\Rule;
use Carbon\Carbon;
use Yajra\DataTables\Facades\DataTables;


class DailybookController extends Controller
{
    public function index(Request $request)
    {
        $date = $request->input('date', Carbon::today()->toDateString());

        $entries = DailyBookEntry::with(['ledgerType', 'ledgerSubcategory', 'creator'])
            ->whereDate('entry_date', $date)
            ->orderBy('id', 'asc')
            ->get();

        return view('dailybook.index', compact('entries', 'date'));
    }
    /*public function index()
	{
	    $totals = [
	        'receipt' => DailybookEntry::where('type','receipt')->sum('amount'),
	        'payment' => DailybookEntry::where('type','payment')->sum('amount'),
	        'expense' => DailybookEntry::where('type','expense')->sum('amount'),
	    ];
	    return view('dailybook.index', compact('totals'));
	}
*/
	public function getData(Request $request)
	{
	    $date = $request->get('date', now()->toDateString());

	    $query = DailyBookEntry::with(['ledgerType', 'ledgerSubcategory'])
	        ->whereDate('entry_date', $date)
	        ->orderBy('id', 'desc');

	    return DataTables::of($query)
		    ->addColumn('sr_no', function ($row) {
	                static $count = 0;
	                return ++$count;
	            })
	        // ->addIndexColumn() // this gives sr_no automatically
	        //->addColumn('ledger_type', fn($row) => $row->ledgerType->name ?? '-')
	        ->addColumn('ledger_type', function ($row) {
                return isset($row->ledgerType) ? $row->ledgerType->name : '-';
            })
	        ->addColumn('ledger_subcategory', function ($row) {
                if (!$row->ledgerType) {
                    return '-';
                }

                switch ($row->ledgerType->name) {
                    case 'Customer / Supplier':
                        if ($row->contact) {
                            return $row->contact->supplier_business_name 
                                ?: $row->contact->name;
                        }
                        return '-';

                    case 'Partners':
                        return $row->partner ? $row->partner->name : '-';

                    default:
                        return $row->ledgerSubcategory ? $row->ledgerSubcategory->name : '-';
                }
            })
	        // ->addColumn('ledger_subcategory', fn($row) => $row->ledgerSubcategory->name ?? '-')
	        ->editColumn('debit', fn($row) => number_format($row->debit, 2))
	        ->editColumn('credit', fn($row) => number_format($row->credit, 2))
	        ->addColumn('source', fn($row) =>
	            '<span class="badge badge-info">'.ucfirst($row->source).'</span>'
	        )
	        ->rawColumns(['source']) // allow HTML badge
	        ->make(true);
	}


    public function create()
    {
       /*$customers = Contact::where('type', 'customer')
		    ->orderBy('name')
		    ->pluck('name', 'id');*/
		$customers = Contact::where('type', 'customer')
		    ->orderBy('name')
		    ->get()
		    ->mapWithKeys(function ($contact) {
		        $displayName = !empty($contact->name) ? $contact->name : $contact->supplier_business_name;
		        return [$contact->id => $displayName];
		    });


		// dd($customers);

		/*$suppliers = Contact::where('type', 'supplier')
		    ->orderBy('name')
		    ->pluck('name', 'id');*/

		$suppliers = Contact::where('type', 'supplier')
		    ->orderBy('name')
		    ->get()
		    ->mapWithKeys(function ($contact) {
		        $displayName = !empty($contact->name) ? $contact->name : $contact->supplier_business_name;
		        return [$contact->id => $displayName];
		    });


		// dd($suppliers);

		$expenseLedgers = Ledger::expenses()
		    ->orderBy('name')
		    ->pluck('name', 'id');

		$moneyLedgers = [
		    'cash' => 'Cash',
		    'bank' => 'Bank',
		    'customer' => 'Customer',
		    'supplier' => 'Supplier',
		    'expense' => 'Expense',
		];


		// $moneyLedgers = Ledger::money()
		//     ->orderBy('name')
		//     ->pluck('name', 'id'); // for mode selection

		return view('dailybook.create', compact('customers','suppliers','expenseLedgers','moneyLedgers'));

    }

    public function profitLossReport(Request $request)
	{
	    // Default to current month if no date range
	    $from = $request->from ?? now()->startOfMonth()->format('Y-m-d');
	    $to = $request->to ?? now()->endOfMonth()->format('Y-m-d');

	    return view('dailybook.profit_loss_report', compact('from', 'to'));
	}

	public function getProfitLossData(Request $request)
	{
	    $from = $request->from ?? now()->startOfMonth()->format('Y-m-d');
	    $to = $request->to ?? now()->endOfMonth()->format('Y-m-d');

	    // Base query for all daily book entries
	    $query = DailyBookEntry::with(['ledgerType', 'ledgerSubcategory', 'partner'])
	        ->whereBetween('entry_date', [$from, $to]);

	    // Totals based on debit/credit
	    $total_sales = (clone $query)
	        ->where('source', 'sale')
	        ->sum('credit');

	    $total_purchase = (clone $query)
	        ->where('source', 'purchase')
	        ->sum('debit');

	    /*$office_expense = (clone $query)
	        ->where('source', 'expense')
	        ->sum('debit');*/

	    $office_expense = (clone $query)
	        ->where('ledger_type_id', 3)
	        ->sum('debit'); // expenses are debits
	        
	    // Net profit calculation
	    $net_profit = $total_sales - $total_purchase - $office_expense;

	    // Fetch partners
	    $partners = BusinessPartner::select('id', 'name', 'percentage')->get();

	    // Build partner-wise data
	    $data = $partners->map(function ($partner) use ($net_profit, $from, $to) {

	        // Partner share based on percentage
	        $share = ($net_profit * $partner->percentage) / 100;

	        // Partner personal expense (debit)
	        $personal_expense = DailyBookEntry::whereBetween('entry_date', [$from, $to])
	            ->where('ledger_type_id', function ($q) {
	                $q->select('id')
	                  ->from('ledger_types')
	                  ->where('name', 'Partners')
	                  ->limit(1);
	            })
	            ->where('ledger_subcategory_id', $partner->id) // assuming subcategory is partner
	            ->sum('debit');

	        // Final amount = share - personal expense
	        $final_amount = $share - $personal_expense;

	        return [
	            'partner' => $partner->name,
	            'percentage' => $partner->percentage . '%',
	            'share_amount' => number_format($share, 2),
	            'personal_expense' => number_format($personal_expense, 2),
	            'final_amount' => number_format($final_amount, 2),
	        ];
	    });

	    return response()->json([
	        'from' => $from,
	        'to' => $to,
	        'total_sales' => number_format($total_sales, 2),
	        'total_purchase' => number_format($total_purchase, 2),
	        'office_expense' => number_format($office_expense, 2),
	        'net_profit' => number_format($net_profit, 2),
	        'data' => $data,
	    ]);
	}



	public function BKgetProfitLossData(Request $request)
	{
	    $from = $request->from ?? now()->startOfMonth()->format('Y-m-d');
	    $to = $request->to ?? now()->endOfMonth()->format('Y-m-d');

	    // Base query
    	$query = DailyBookEntry::with(['ledgerType', 'ledgerSubcategory', 'partner'])
        ->whereBetween('entry_date', [$from, $to]);

         /**
	     * Assumptions:
	     *  - ledger_type_id or ledger_subcategory_id indicates the type of entry.
	     *  - You can adjust these conditions to match your actual setup.
	     */

	    // Identify your IDs for each type
	    $saleTypeId = 1;       // example: ID for Sale in ledger_types table
	    $purchaseTypeId = 2;   // example: ID for Purchase
	    $expenseTypeId = 3;    // example: ID for Expense

	    // Totals based on debit/credit logic
	    $total_sales = (clone $query)
	        ->where('source', 'sale')
	        ->sum('credit'); // money coming in

	    $total_purchase = (clone $query)
	        ->where('source', 'purchase')
	        ->sum('debit'); // money going out

	    $office_expense = (clone $query)
	        ->where('ledger_type_id', 3)
	        ->sum('debit'); // expenses are debits

	    //  Net profit formula
	    $net_profit = $total_sales - $total_purchase - $office_expense;

	    //  Partner share calculation
	    $partners = BusinessPartner::select('id', 'name', 'percentage')->get();

	    $data = $partners->map(function ($partner) use ($net_profit) {
	        $share = ($net_profit * $partner->percentage) / 100;
	        return [
	            'partner' => $partner->name,
	            'percentage' => $partner->percentage . '%',
	            'share_amount' => number_format($share, 2),
	        ];
	    });

	    return response()->json([
	        'from' => $from,
	        'to' => $to,
	        'total_sales' => number_format($total_sales, 2),
	        'total_purchase' => number_format($total_purchase, 2),
	        'office_expense' => number_format($office_expense, 2),
	        'net_profit' => number_format($net_profit, 2),
	        'data' => $data,
	    ]);
	}

   /*public function store(Request $request, DailybookPoster $poster)
	{
	    $baseRules = [
	        'entry_date' => ['required','date'],
	        'type'       => ['required','in:receipt,payment,expense'],
	        'amount'     => ['required','numeric','min:0.01'],
	        'mode'       => ['required','in:cash,bank,customer,supplier,expense'], // ✅ now validates actual ledger_id
	        'reference'  => ['nullable','string','max:190'],
	        'notes'      => ['nullable','string'],
	    ];

	    // Conditional rules
	    if ($request->type === 'receipt') {
	        // receipt must be linked to a customer contact
	        $baseRules['customer_id'] = [
	            'required',
	            Rule::exists('contacts', 'id')->where('type', 'customer')
	        ];
	    } elseif ($request->type === 'payment') {
	        // payment must be linked to a supplier contact
	        $baseRules['supplier_id'] = [
	            'required',
	            Rule::exists('contacts', 'id')->where('type', 'supplier')
	        ];
	    } elseif ($request->type === 'expense') {
	        // expense must be linked to a valid expense ledger
	        $baseRules['expense_ledger_id'] = [
	            'required',
	            Rule::exists('ledgers', 'id')->where('type', 'expense')
	        ];
	    }

	    $data = $request->validate($baseRules);
	    $data['created_by'] = Auth::id();

	    $entry = DailybookEntry::create($data);

	    // ✅ Post to ledgers (double-entry)
	    $poster->post($entry);

	    return redirect()->route('dailybook.index')
	        ->with('success', 'Dailybook entry recorded and posted to ledgers.');
	}*/


    /*public function destroy(DailybookEntry $dailybook)
    {
        // rollback transactions before delete
        $dailybook->transactions()->delete();
        $dailybook->delete();

        return redirect()->route('dailybook.index')
            ->with('success','Entry deleted successfully.');
    }*/
}
