<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class DailyBookEntry extends Model
{   
    // protected $table = 'daily_book_entries';
    
    protected $fillable = [
        'entry_date',
        'source',
        'ledger_type_id',
        'ledger_subcategory_id',
        'detail',
        'debit',
        'credit',
        'created_by',
        'reference_id',
        'reference_type',
    ];

    protected $casts = [
        'entry_date' => 'date',
    ];

    // Relations
    public function ledgerType(): BelongsTo
    {
        return $this->belongsTo(LedgerType::class, 'ledger_type_id');
    }

    /*public function ledgerSubcategory(): BelongsTo
    {
        return $this->belongsTo(LedgerSubcategory::class, 'ledger_subcategory_id');
    }*/

    public function creator(): BelongsTo
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function contact()
    {
        return $this->belongsTo(Contact::class, 'ledger_subcategory_id');
    }

    public function partner()
    {
        return $this->belongsTo(BusinessPartner::class, 'ledger_subcategory_id');
    }

    public function ledgerSubcategory()
    {
        return $this->belongsTo(LedgerSubcategory::class, 'ledger_subcategory_id');
    }
}
