<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class BusinessPartner extends Model
{
    protected $guarded = ['id'];

    /**
     * Return list of partners for a business
     *
     * @param int $business_id
     * @param bool $show_all
     * @return \Illuminate\Support\Collection
     */
    public static function forDropdown($business_id, $show_all = false)
    {
        $query = BusinessPartner::where('business_id', $business_id);

        $partners = $query->pluck('name', 'id');

        if ($show_all) {
            $partners->prepend(__('report.all_partners'), '');
        }

        return $partners;
    }

    /**
     * Scope a query to only include active partners.
     */
    public function scopeActive($query)
    {
        return $query->where('is_active', 1);
    }

    /**
     * Relation with business
     */
    public function business()
    {
        return $this->belongsTo(\App\Business::class);
    }

    /**
     * Accessor for display percentage with %
     */
    public function getDisplayPercentageAttribute()
    {
        return $this->percentage . '%';
    }
}
