<!DOCTYPE html>
<html lang="ar" dir="<?php echo e($appDirection); ?>">
<head>
    <meta charset="UTF-8">
    <title><?php echo e($printData['name']); ?></title>
    <?php echo $__env->make('print.common.css', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</head>
<body onload="window.print();">
    <div class="invoice-container">
        <span class="invoice-name"><?php echo e($printData['name']); ?></span>
        <div class="invoice">
            <table class="header">
                <tr>
                    <?php echo $__env->make('print.common.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    <td class="bill-info">
                        <span class="bill-number">#: <?php echo e($transfer->transfer_code); ?></span><br>
                        <span class="cu-fs-16"><?php echo e(__('app.date')); ?>: <?php echo e($transfer->formatted_transfer_date); ?></span><br>
                        <span class="cu-fs-16"><?php echo e(__('app.time')); ?>: <?php echo e($transfer->format_created_time); ?></span><br>
                    </td>
                </tr>
            </table>

         <?php
            $isHasBatchItem = ($transfer->itemTransaction->where('tracking_type', 'batch')->count() > 0) ? true : false;

            //Return from Controller
            $totalBatchTrackingRowCount = ($isHasBatchItem) ? $batchTrackingRowCount : 0;
        ?>
        <table class="table-bordered custom-table table-compact" id="item-table">
            <thead>
                <tr>
                    <th>#</th>
                    <th><?php echo e(__('warehouse.from_warehouse')); ?></th>
                    <th><?php echo e(__('warehouse.to_warehouse')); ?></th>
                    <th><?php echo e(__('item.item')); ?></th>
                    <?php if(app('company')['show_hsn']): ?>
                    <th><?php echo e(__('item.hsn')); ?></th>
                    <?php endif; ?>
                    <?php if($isHasBatchItem): ?>
                        <?php if(app('company')['enable_batch_tracking']): ?>
                        <th><?php echo e(__('item.batch_no')); ?></th>
                        <?php endif; ?>
                        <?php if(app('company')['enable_mfg_date']): ?>
                        <th><?php echo e(__('item.mfg_date')); ?></th>
                        <?php endif; ?>
                        <?php if(app('company')['enable_exp_date']): ?>
                        <th><?php echo e(__('item.exp_date')); ?></th>
                        <?php endif; ?>
                        <?php if(app('company')['enable_model']): ?>
                        <th><?php echo e(__('item.model_no')); ?></th>
                        <?php endif; ?>

                        <?php if(app('company')['enable_color']): ?>
                        <th><?php echo e(__('item.color')); ?></th>
                        <?php endif; ?>
                        <?php if(app('company')['enable_size']): ?>
                        <th><?php echo e(__('item.size')); ?></th>
                        <?php endif; ?>
                    <?php endif; ?>
                    <?php if(app('company')['show_mrp']): ?>
                    <th><?php echo e(__('item.mrp')); ?></th>
                    <?php endif; ?>
                    <th><?php echo e(__('app.qty')); ?></th>


                </tr>
            </thead>
            <tbody>
                <?php
                    $i=1;
                ?>

                <?php $__currentLoopData = $transfer->itemTransaction; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                   <td class="no"><?php echo e($i++); ?></td>
                   <td>
                    <?php echo e($transaction->itemStockTransfer->fromWarehouse->name); ?>

                   </td>
                   <td>
                    <?php echo e($transaction->itemStockTransfer->toWarehouse->name); ?>

                   </td>
                    <td class="">
                        <!-- Service Name -->
                        <b><?php echo e($transaction->item->name); ?></b>
                        <!-- Description -->
                        <small><?php echo e($transaction->description); ?></small>
                        <small>
                            <?php if($transaction->itemSerialTransaction->count() > 0): ?>
                                <br><?php echo e($transaction->itemSerialTransaction->pluck('itemSerialMaster.serial_code')->implode(',')); ?><br>
                            <?php endif; ?>
                        </small>
                   </td>
                   <?php if(app('company')['show_hsn']): ?>
                   <td>
                       <?php echo e($transaction->item->hsn); ?>

                   </td>
                   <?php endif; ?>
                   <?php if($isHasBatchItem): ?>

                       <?php if(app('company')['enable_batch_tracking']): ?>
                       <td>
                           <?php echo e($transaction->batch ? $transaction->batch->itemBatchMaster->batch_no : ''); ?>

                       </td>
                       <?php endif; ?>
                       <?php if(app('company')['enable_mfg_date']): ?>
                       <td>
                           <?php echo e($transaction->batch ? $formatDate->toUserDateFormat($transaction->batch->itemBatchMaster->mfg_date) : ''); ?>

                       </td>
                       <?php endif; ?>
                       <?php if(app('company')['enable_exp_date']): ?>
                       <td>
                           <?php echo e($transaction->batch ? $formatDate->toUserDateFormat($transaction->batch->itemBatchMaster->exp_date) : ''); ?>

                       </td>
                       <?php endif; ?>
                       <?php if(app('company')['enable_model']): ?>
                       <td>
                           <?php echo e($transaction->batch ? $transaction->batch->itemBatchMaster->model_no : ''); ?>

                       </td>
                       <?php endif; ?>

                       <?php if(app('company')['enable_color']): ?>
                       <td>
                           <?php echo e($transaction->batch ? $transaction->batch->itemBatchMaster->color :''); ?>

                       </td>
                       <?php endif; ?>
                       <?php if(app('company')['enable_size']): ?>
                       <td>
                           <?php echo e($transaction->batch ? $transaction->batch->itemBatchMaster->size : ''); ?>

                       </td>
                       <?php endif; ?>
                   <?php endif; ?>
                   <?php if(app('company')['show_mrp']): ?>
                   <td>
                       <?php echo e($formatNumber->formatWithPrecision($transaction->batch ? $transaction->batch->itemBatchMaster->mrp : $transaction->mrp)); ?>

                   </td>
                   <?php endif; ?>
                   <td class="text-end">
                        <?php echo e($formatNumber->formatQuantity($transaction->quantity)); ?>

                    </td>

                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <tr class="fw-bold">
                    <td class="text-end" colspan="<?php echo e(4 + $totalBatchTrackingRowCount + app('company')['show_mrp'] + app('company')['show_hsn']); ?>">
                            <?php echo e(__('app.total')); ?>

                    </td>
                    <td class="text-end">
                            <?php echo e($formatNumber->formatWithPrecision($transfer->itemTransaction->sum('quantity'))); ?>

                    </td>


                </tr>
            </tbody>

        </table>



        <?php echo $__env->make('print.common.bank-signature', ['hideBankDetails'=> true], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


    </div>
    </div>
</body>
</html>
<?php /**PATH /home/harrxcms/hamzaent.org/resources/views/print/stock-transfer/print.blade.php ENDPATH**/ ?>